#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_ProviderData : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}

		[Test]
		public void GetVistaProviderData_Pass()
		{
			Assert.IsTrue( DAL.VAL.Provider.GetVistaProvider( "589A5", "T" ).Rows.Count > 0 );
		}

		[Test]
		public void GetVistaProviderData_Pass_2()
		{
			Assert.IsTrue( DAL.VAL.Provider.GetVistaProvider( "589", String.Empty ).Rows.Count > 0 );
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void GetVistaProviderData_Fail()
		{
			DAL.VAL.Provider.GetVistaProvider( null, "A" );
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void GetVistaProviderData_Fail_2()
		{
			DAL.VAL.Provider.GetVistaProvider( "589", null );
		}
	}
}
#endif
